/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.jellyfishingdelight.mixin;

import club.someoneice.jellyfishingdelight.core.BlockList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.TextUtils;

@Mixin(value={SkilletBlockEntity.class})
public abstract class SkilletMixin {
    @Shadow(remap=false)
    private int cookingTime;
    @Shadow(remap=false)
    private int cookingTimeTotal;
    @Shadow(remap=false)
    private int fireAspectLevel;
    @Shadow(remap=false)
    private ResourceLocation lastRecipeID;

    @Shadow(remap=false)
    protected abstract Optional<CampfireCookingRecipe> getMatchingRecipe(Container var1);

    @Shadow(remap=false)
    protected abstract void cookAndOutputItems(ItemStack var1, Level var2);

    @Inject(method={"cookingTick"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void reCookingTick(Level level, BlockPos pos, BlockState state, SkilletBlockEntity thiz, CallbackInfo ci) {
        Level world = thiz.m_58904_();
        if (Objects.isNull(world) || !((Boolean)thiz.m_58900_().m_61143_((Property)CookingPotBlock.WATERLOGGED)).booleanValue() || !world.m_8055_(thiz.m_58899_().m_7495_()).m_60713_((Block)BlockList.GRILL.get())) {
            return;
        }
        ((SkilletMixin)thiz).jellyfishingdelight$cookingTimeIn(thiz);
        ci.cancel();
    }

    @Unique
    private void jellyfishingdelight$cookingTimeIn(SkilletBlockEntity thiz) {
        ItemStack cookingStack = thiz.getStoredStack();
        if (cookingStack.m_41619_()) {
            this.cookingTime = 0;
        } else {
            this.cookAndOutputItems(cookingStack, thiz.m_58904_());
        }
    }

    @Inject(method={"addItemToCook"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void reAddItemToCook(ItemStack addedStack, Player player, CallbackInfoReturnable<ItemStack> cir) {
        SkilletBlockEntity thiz = (SkilletBlockEntity)this;
        Level world = thiz.m_58904_();
        if (Objects.isNull(world) || !((Boolean)thiz.m_58900_().m_61143_((Property)CookingPotBlock.WATERLOGGED)).booleanValue() || !world.m_8055_(thiz.m_58899_().m_7495_()).m_60713_((Block)BlockList.GRILL.get())) {
            return;
        }
        Optional<CampfireCookingRecipe> recipe = this.getMatchingRecipe((Container)new SimpleContainer(new ItemStack[]{addedStack}));
        if (!recipe.isPresent()) {
            player.m_5661_((Component)TextUtils.getTranslation((String)"block.skillet.invalid_item", (Object[])new Object[0]), true);
            cir.setReturnValue((Object)addedStack);
        }
        this.cookingTimeTotal = SkilletBlock.getSkilletCookingTime((int)recipe.get().m_43753_(), (int)this.fireAspectLevel);
        ItemStack itemIn = thiz.getStoredStack();
        if (itemIn.m_41619_()) {
            thiz.getInventory().insertItem(0, addedStack.m_41777_(), false);
            addedStack.m_41764_(0);
            world.m_6263_(null, (double)((float)thiz.m_58899_().m_123341_() + 0.5f), (double)((float)thiz.m_58899_().m_123342_() + 0.5f), (double)((float)thiz.m_58899_().m_123343_() + 0.5f), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        }
        if (!ItemStack.m_41728_((ItemStack)itemIn, (ItemStack)addedStack) || itemIn.m_41613_() >= itemIn.m_41741_()) {
            cir.setReturnValue((Object)addedStack);
        }
        thiz.getInventory().insertItem(0, addedStack.m_41777_(), false);
        addedStack.m_41764_(addedStack.m_41613_() - (addedStack.m_41741_() - itemIn.m_41613_()));
        cir.setReturnValue((Object)addedStack);
    }
}

